<?php
/**
 * PropertiesObject
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  onesignal\client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OneSignal
 *
 * A powerful way to send personalized messages at scale and build effective customer engagement strategies. Learn more at onesignal.com
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: devrel@onesignal.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace onesignal\client\model;

use \ArrayAccess;
use \onesignal\client\ObjectSerializer;

/**
 * PropertiesObject Class Doc Comment
 *
 * @category Class
 * @package  onesignal\client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class PropertiesObject implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PropertiesObject';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'tags' => 'array<string,mixed>',
        'language' => 'string',
        'timezone_id' => 'string',
        'lat' => 'float',
        'long' => 'float',
        'country' => 'string',
        'first_active' => 'float',
        'last_active' => 'float',
        'amount_spent' => 'float',
        'purchases' => '\onesignal\client\model\Purchase[]',
        'ip' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'tags' => null,
        'language' => null,
        'timezone_id' => null,
        'lat' => null,
        'long' => null,
        'country' => null,
        'first_active' => null,
        'last_active' => null,
        'amount_spent' => null,
        'purchases' => null,
        'ip' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'tags' => 'tags',
        'language' => 'language',
        'timezone_id' => 'timezone_id',
        'lat' => 'lat',
        'long' => 'long',
        'country' => 'country',
        'first_active' => 'first_active',
        'last_active' => 'last_active',
        'amount_spent' => 'amount_spent',
        'purchases' => 'purchases',
        'ip' => 'ip'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'tags' => 'setTags',
        'language' => 'setLanguage',
        'timezone_id' => 'setTimezoneId',
        'lat' => 'setLat',
        'long' => 'setLong',
        'country' => 'setCountry',
        'first_active' => 'setFirstActive',
        'last_active' => 'setLastActive',
        'amount_spent' => 'setAmountSpent',
        'purchases' => 'setPurchases',
        'ip' => 'setIp'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'tags' => 'getTags',
        'language' => 'getLanguage',
        'timezone_id' => 'getTimezoneId',
        'lat' => 'getLat',
        'long' => 'getLong',
        'country' => 'getCountry',
        'first_active' => 'getFirstActive',
        'last_active' => 'getLastActive',
        'amount_spent' => 'getAmountSpent',
        'purchases' => 'getPurchases',
        'ip' => 'getIp'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['tags'] = $data['tags'] ?? null;
        $this->container['language'] = $data['language'] ?? null;
        $this->container['timezone_id'] = $data['timezone_id'] ?? null;
        $this->container['lat'] = $data['lat'] ?? null;
        $this->container['long'] = $data['long'] ?? null;
        $this->container['country'] = $data['country'] ?? null;
        $this->container['first_active'] = $data['first_active'] ?? null;
        $this->container['last_active'] = $data['last_active'] ?? null;
        $this->container['amount_spent'] = $data['amount_spent'] ?? null;
        $this->container['purchases'] = $data['purchases'] ?? null;
        $this->container['ip'] = $data['ip'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets tags
     *
     * @return array<string,mixed>|null
     */
    public function getTags()
    {
        return $this->container['tags'];
    }

    /**
     * Sets tags
     *
     * @param array<string,mixed>|null $tags tags
     *
     * @return self
     */
    public function setTags($tags)
    {
        $this->container['tags'] = $tags;

        return $this;
    }

    /**
     * Gets language
     *
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->container['language'];
    }

    /**
     * Sets language
     *
     * @param string|null $language language
     *
     * @return self
     */
    public function setLanguage($language)
    {
        $this->container['language'] = $language;

        return $this;
    }

    /**
     * Gets timezone_id
     *
     * @return string|null
     */
    public function getTimezoneId()
    {
        return $this->container['timezone_id'];
    }

    /**
     * Sets timezone_id
     *
     * @param string|null $timezone_id timezone_id
     *
     * @return self
     */
    public function setTimezoneId($timezone_id)
    {
        $this->container['timezone_id'] = $timezone_id;

        return $this;
    }

    /**
     * Gets lat
     *
     * @return float|null
     */
    public function getLat()
    {
        return $this->container['lat'];
    }

    /**
     * Sets lat
     *
     * @param float|null $lat lat
     *
     * @return self
     */
    public function setLat($lat)
    {
        $this->container['lat'] = $lat;

        return $this;
    }

    /**
     * Gets long
     *
     * @return float|null
     */
    public function getLong()
    {
        return $this->container['long'];
    }

    /**
     * Sets long
     *
     * @param float|null $long long
     *
     * @return self
     */
    public function setLong($long)
    {
        $this->container['long'] = $long;

        return $this;
    }

    /**
     * Gets country
     *
     * @return string|null
     */
    public function getCountry()
    {
        return $this->container['country'];
    }

    /**
     * Sets country
     *
     * @param string|null $country country
     *
     * @return self
     */
    public function setCountry($country)
    {
        $this->container['country'] = $country;

        return $this;
    }

    /**
     * Gets first_active
     *
     * @return float|null
     */
    public function getFirstActive()
    {
        return $this->container['first_active'];
    }

    /**
     * Sets first_active
     *
     * @param float|null $first_active first_active
     *
     * @return self
     */
    public function setFirstActive($first_active)
    {
        $this->container['first_active'] = $first_active;

        return $this;
    }

    /**
     * Gets last_active
     *
     * @return float|null
     */
    public function getLastActive()
    {
        return $this->container['last_active'];
    }

    /**
     * Sets last_active
     *
     * @param float|null $last_active last_active
     *
     * @return self
     */
    public function setLastActive($last_active)
    {
        $this->container['last_active'] = $last_active;

        return $this;
    }

    /**
     * Gets amount_spent
     *
     * @return float|null
     */
    public function getAmountSpent()
    {
        return $this->container['amount_spent'];
    }

    /**
     * Sets amount_spent
     *
     * @param float|null $amount_spent amount_spent
     *
     * @return self
     */
    public function setAmountSpent($amount_spent)
    {
        $this->container['amount_spent'] = $amount_spent;

        return $this;
    }

    /**
     * Gets purchases
     *
     * @return \onesignal\client\model\Purchase[]|null
     */
    public function getPurchases()
    {
        return $this->container['purchases'];
    }

    /**
     * Sets purchases
     *
     * @param \onesignal\client\model\Purchase[]|null $purchases purchases
     *
     * @return self
     */
    public function setPurchases($purchases)
    {
        $this->container['purchases'] = $purchases;

        return $this;
    }

    /**
     * Gets ip
     *
     * @return string|null
     */
    public function getIp()
    {
        return $this->container['ip'];
    }

    /**
     * Sets ip
     *
     * @param string|null $ip ip
     *
     * @return self
     */
    public function setIp($ip)
    {
        $this->container['ip'] = $ip;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


