<div class="main-content">

<div class="page-content">

    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="page-title mb-0 font-size-18">Dashboard</h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">Pages</a></li>
                        <li class="breadcrumb-item active">Dashboard</li>
                    </ol>
                </div>

            </div>
        </div>
    </div>
    <!-- end page title -->
    <div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 row-cols-xl-4 row-cols-xxl-4">
        <div class="col-lg-4">
            <div class="card bg-primary text-white-50">
                <div class="card-body">
                    <h5 class="mt-0 mb-4 text-white"><i class="fa-duotone fa-person me-3"></i>Customer</h5>
                    <p class="card-text">Total Customers Saat Ini Berjumlah <?= count($customer); ?> Akun</p>
                </div>
            </div>
        </div>
        <div class="col-lg-4">
            <div class="card bg-primary text-white-50">
                <div class="card-body">
                    <h5 class="mt-0 mb-4 text-white"><i class="fa-duotone fa-person me-3"></i>Driver</h5>
                    <p class="card-text">Total Driver Saat Ini Berjumlah <?= count($driver); ?> Akun</p>
                </div>
            </div>
        </div>
        <div class="col-lg-4">
            <div class="card bg-dark text-white-50">
                <div class="card-body">
                    <h5 class="mt-0 mb-4 text-white"><i class="fa-duotone fa-money-from-bracket me-3"></i>Transaksi</h5>
                    <p class="card-text">Total Transaksi Saat Ini Berjumlah <?= count($transaksi); ?> Transaksi</p>
                </div>
            </div>
        </div>  
        <div class="col-lg-4">
            <div class="card bg-info text-white-50">
                <div class="card-body">
                    <h5 class="mt-0 mb-4 text-white"><i class="fa-duotone fa-money-bill me-3"></i>Nominal</h5>
                    <p class="card-text">Nominal Transaksi Saat Ini Rp<?= rupiah($trx_all) ?></p>
                </div>
            </div>
        </div>  
           
    </div>
    <table id="tableakun" class="table table-bordered dt-responsive nowrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
    <thead>
    <tr>
        <th>No</th>
        <th>Idtrans</th>
        <th>Fitur</th>
        <th>Customer</th>
        <th>Driver</th>
        <th>Total Harga</th>
        <th>Waktu</th>
        <th>Status</th>
    </tr>
    </thead>

    <tbody>
    <?php $i = 1;
        foreach ($ontransaksi as $ak) { ?>
    <tr>
        <td><?= $i ?></td>
        <td><?= $ak['idtrans']; ?></td>
        <td><?= $ak['fitur']; ?></td>
        <td><?= $ak['namapelanggan']; ?></td>
        <td><?= $ak['namadriver']; ?></td>
        <td>Rp<?= rupiah($ak['totalharga']); ?></td>
        <td><?= date("d M Y H:i", strtotime($ak['waktu'])); ?></td>
        <?php if ($ak['status'] == '0') { ?>
            <td><span  style="color:black">Mencari</span></td>
        <?php } else if ($ak['status'] == '1') { ?>
            <td><span  style="color:purple">Dikonfirmasi</span></td>
        <?php } else if ($ak['status'] == '2') { ?>
            <td><span  style="color:blue">Penjemputan</span></td>
        <?php } else if ($ak['status'] == '3') { ?>
            <td><span  style="color:orange">Pengantaran</span></td>
        <?php } else if ($ak['status'] == '4') { ?>
            <td><span  style="color:green">Selesai</span></td>
        <?php } else if ($ak['status'] == '5') { ?>
            <td><span  style="color:red">Dibatalkan</span></td>
        <?php } ?>
    </tr>
    <?php $i++;
                } ?>
    </tbody>
    </table>
</div>
<!-- End Page-content -->