<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, viewport-fit=cover, shrink-to-fit=no">
    <meta name="description" content="<?= $page['appname'] ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="theme-color" content="#100DD1">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
    <!-- The above tags *must* come first in the head, any other head content must come *after* these tags -->
    <!-- Title -->
    <title><?= $page['appname'] ?></title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@300;400;500;600;700&amp;display=swap" rel="stylesheet">
    <!-- Favicon -->
    <link rel="icon" href="<?= base_url(); ?>assets/img/icons/icon-72x72.png">
    <!-- Apple Touch Icon -->
    <link rel="apple-touch-icon" href="<?= base_url(); ?>assets/img/icons/icon-96x96.png">
    <link rel="apple-touch-icon" sizes="152x152" href="<?= base_url(); ?>assets/img/icons/icon-152x152.png">
    <link rel="apple-touch-icon" sizes="167x167" href="<?= base_url(); ?>assets/img/icons/icon-167x167.png">
    <link rel="apple-touch-icon" sizes="180x180" href="<?= base_url(); ?>assets/img/icons/icon-180x180.png">
    <!-- CSS Libraries -->
    <link rel="stylesheet" href="<?= base_url(); ?>assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="<?= base_url(); ?>assets/css/animate.css">
    <link rel="stylesheet" href="<?= base_url(); ?>assets/css/all.min.css">
    <link rel="stylesheet" href="<?= base_url(); ?>assets/css/brands.min.css">
    <link rel="stylesheet" href="<?= base_url(); ?>assets/css/solid.min.css">
    <link rel="stylesheet" href="<?= base_url(); ?>assets/css/owl.carousel.min.css">
    <link rel="stylesheet" href="<?= base_url(); ?>assets/css/magnific-popup.css">
    <link rel="stylesheet" href="<?= base_url(); ?>assets/css/nice-select.css">
    <!-- Stylesheet -->
    <link rel="stylesheet" href="<?= base_url(); ?>assets/style.css">
    <!-- Web App Manifest -->
    <link rel="manifest" href="<?= base_url(); ?>assets/manifest.json">
  </head>
  <body>
    <!-- Preloader-->
    <div class="preloader" id="preloader">
      <div class="spinner-grow text-secondary" role="status">
        <div class="sr-only"></div>
      </div>
    </div>
    <!-- Login Wrapper Area-->
    <div class="login-wrapper d-flex align-items-center justify-content-center text-center">
      <!-- Background Shape-->
      <div class="background-shape"></div>
      <div class="container">
        <div class="row justify-content-center">
          <div class="col-10 col-lg-8"><img class="big-logo" src="<?= base_url(); ?>images/<?= $page['logo_white']; ?>" alt="">
            <!-- Register Form-->
           
            <div class="register-form mt-5">
            <?= form_open_multipart('login/aksi_login'); ?>
              
                <div class="form-group text-start mb-4"><span>Username</span>
                  <label for="username"><i class="fa-solid fa-user"></i></label>
                  <input class="form-control" id="username" name="username" type="text" placeholder="username"  required>
                </div>
                <div class="form-group text-start mb-4"><span>Password</span>
                  <label for="password"><i class="fa-solid fa-key"></i></label>
                  <input class="form-control" id="password" name="password" type="password" placeholder="Password" required>
                </div>
                <?php if ($this->session->flashdata()) : ?>
                <div class="alert alert-danger" role="alert">
                    <?php echo $this->session->flashdata('error'); ?>
                </div>
                <?php endif; ?>
                <button class="btn btn-warning btn-lg w-100" type="submit">Masuk</button>
            </form>
           
            </div>
            
            <!-- Login Meta-->
            <div class="login-meta-data"><a class="forgot-password d-block mt-3 mb-1" href="forget-password.html">Forgot Password?</a>
              <p class="mb-0">Belum Punya Akun?<a class="mx-1" href="<?= base_url(); ?>login/daftar">Buat Sekarang</a></p>
            </div>
           
        </div>
      </div>
    </div>
    <!-- All JavaScript Files-->
    <script src="<?= base_url(); ?>assets/js/bootstrap.bundle.min.js"></script>
    <script src="<?= base_url(); ?>assets/js/jquery.min.js"></script>
    <script src="<?= base_url(); ?>assets/js/waypoints.min.js"></script>
    <script src="<?= base_url(); ?>assets/js/jquery.easing.min.js"></script>
    <script src="<?= base_url(); ?>assets/js/jquery.magnific-popup.min.js"></script>
    <script src="<?= base_url(); ?>assets/js/owl.carousel.min.js"></script>
    <script src="<?= base_url(); ?>assets/js/jquery.counterup.min.js"></script>
    <script src="<?= base_url(); ?>assets/js/jquery.countdown.min.js"></script>
    <script src="<?= base_url(); ?>assets/js/jquery.passwordstrength.js"></script>
    <script src="<?= base_url(); ?>assets/js/jquery.nice-select.min.js"></script>
    <script src="<?= base_url(); ?>assets/js/theme-switching.js"></script>
    <script src="<?= base_url(); ?>assets/js/active.js"></script>
    <!--<script src="<?= base_url(); ?>assets/js/pwa.js"></script>-->
    
  </body>
</html>