<?php


class Home_model extends CI_model
{
    public function getappbyid()
    {
        return $this->db->get_where('app_settings', ['id' => '1'])->row_array();
    }
    public function landingpage()
    {
        return $this->db->get_where('settings', ['id' => '1'])->row_array();
    }
    public function get_fitur()
    {
        return  $this->db->get('fitur')->result_array();
    }
    public function get_fiturbyid($id)
    {
        return $this->db->get_where('fitur', ['id' => $id])->row_array();
    }
    function get_datafiturbyid($id)
    {
        $this->db->select('*');
        $this->db->from('fitur');
        $this->db->where('id', $id);
        return $this->db->get();
    }
    public function get_akunbyid($id)
    {
        return $this->db->get_where('pengguna', ['uid' => $id])->row_array();
    }
    public function get_akunbyids($id)
    {
        return $this->db->get_where('pengguna', ['uid' => $id])->result_array();
    }
    function get_pengajuanbyid($id)
    {
        $this->db->select('*');
        $this->db->from('pengajuan');
        $this->db->where('idtrans', $id);
        return $this->db->get()->result_array();
    }
    function get_pengajuanbydriver($id,$iddriver)
    {
        $this->db->select('*');
        $this->db->from('pengajuan');
        $this->db->where("(idtrans = $id AND iddriver = $iddriver)");
        return $this->db->get()->result_array();
        //return $this->db->query("SELECT idtrans FROM pengajuan where idtrans='$id' AND iddriver = '$iddriver' ")->result_array();
    }
    function alldatadriver()
    {
        $this->db->select('*');
        $this->db->from('pengguna');
        $this->db->where('type', '1');
        $this->db->where('order_id', '0');
        return $this->db->get()->result_array();
    }
    
    public function alldatacustomerbytrx($id)
    {
        $this->db->select('transaksi.*');
        $this->db->select('pelanggan.uid,pengguna.token');
        $this->db->from('transaksi');
        $this->db->join('pengguna', 'transaksi.idpelanggan = pelanggan.uid', 'left');
        $this->db->where('idtrans', $id);
        $pelanggan = $this->db->get();
        return $pelanggan;
    }
    public function alldatadriversbytrx($id)
    {
        $this->db->select('transaksi.*');
        $this->db->select('pelanggan.uid,pengguna.token');
        $this->db->from('transaksi');
        $this->db->join('pengguna', 'transaksi.iddriver = pelanggan.uid', 'left');
        $this->db->where('idtrans', $id);
        $pelanggan = $this->db->get();
        return $pelanggan;
    }
    function alldatadriverbytrx($id)
    {
        $this->db->select('transaksi.*,pengguna.token');
        $this->db->from('transaksi');
        $this->db->join('pengguna', 'transaksi.iddriver = pelanggan.uid', 'left');
        $this->db->where('idtrans', $id);
        return $this->db->get()->result_array();
    }
    function get_datapelanggan($id)
    {
        $this->db->select('*');
        $this->db->where('pengguna', $id);
        return $this->db->get()->result_array();
    }
    public function get_banner()
    {
        return  $this->db->get('banner')->result_array();
    }
    public function get_bannerride($id)
    {
        return $this->db->get_where('banner', ['layanan' => $id])->result_array();
    }
    public function getallAkunCustomer()
    {
        return $this->db->get_where('pengguna', ['type' => '0'])->result_array();
    }
    public function getallAkunDriver()
    {
        return $this->db->get_where('pengguna', ['type' => '1'])->result_array();
    }
    public function getalltransaksiproses(){
        $this->db->select('transaksi.*,pelanggan.fullnama as namapelanggan,driver.fullnama as namadriver,fitur.fitur,fitur.layanan');
        $this->db->join('fitur', 'transaksi.fitur = fitur.id', 'left');
        $this->db->join('pengguna as pelanggan', 'transaksi.idpelanggan = pelanggan.uid', 'left');
        $this->db->join('pengguna as driver', 'transaksi.iddriver = driver.uid', 'left');
        $this->db->where('status != 4');
        $this->db->where('status != 5');
        return $this->db->get('transaksi')->result_array();
    }
    public function getalltransaksidashboard(){
        $this->db->select('transaksi.*,pelanggan.fullnama as namapelanggan,driver.fullnama as namadriver,fitur.fitur,fitur.layanan');
        $this->db->join('fitur', 'transaksi.fitur = fitur.id', 'left');
        $this->db->join('pengguna as pelanggan', 'transaksi.idpelanggan = pelanggan.uid', 'left');
        $this->db->join('pengguna as driver', 'transaksi.iddriver = driver.uid', 'left');
        $this->db->where("(status = 4 OR status = 5)", NULL, FALSE);
        return $this->db->get('transaksi')->result_array();
    }
    public function getalltransaksi(){
        $this->db->select('transaksi.*,pelanggan.fullnama as namapelanggan,driver.fullnama as namadriver,fitur.fitur,fitur.layanan');
        $this->db->join('fitur', 'transaksi.fitur = fitur.id', 'left');
        $this->db->join('pengguna as pelanggan', 'transaksi.idpelanggan = pelanggan.uid', 'left');
        $this->db->join('pengguna as driver', 'transaksi.iddriver = driver.uid', 'left');
        $this->db->where('status != 0');
        return $this->db->get('transaksi')->result_array();
    }
    public function transaksi_all(){
        $this->db->select('*');
        $this->db->from('transaksi');
        $this->db->where('status', '4');
        $cek = $this->db->get();
        $countdata = 0;
        $hasil = 0;
        if ($cek->num_rows() > 0) {
            foreach ($cek->result() as $row) {
                $countdata += $row->totalharga;
            }
            $hasil = $countdata;
        }
        return $hasil;
      }
    public function editalamat($data)
    {
        $this->db->set('alamat', $data['alamat']);
        $this->db->set('latitude', $data['latitude']);
        $this->db->set('longitude', $data['longitude']);
        $this->db->where('uid', $data['uid']);
        return $this->db->update('pengguna', $data);
    }
    public function testeditalamat($data)
    {
        $this->db->set('alamat', $data['alamat']);
        $this->db->set('latitude', $data['latitude']);
        $this->db->set('longitude', $data['longitude']);
        $this->db->where('uid', '1');
        return $this->db->update('pengguna', $data);
    }
    public function editprofile($data)
    {
        $this->db->set('username', $data['username']);
        $this->db->set('email', $data['email']);
        $this->db->set('fullnama', $data['fullnama']);
        $this->db->set('kontak', $data['kontak']);
        $this->db->set('foto', $data['foto']);
        $this->db->set('isgps', $data['isgps']);
        $this->db->where('uid', $data['uid']);
        return $this->db->update('pengguna', $data);
    }
    public function appsetting()
    {
      $this->db->select('*');
      $this->db->from('app_settings');
      $this->db->where('id', '1');
      return $this->db->get();
    }
   
    function get_merchant_location()
    {
        $this->db->select('*');
        $this->db->from('merchant');
        $loc = $this->db->get();
        return $loc;
    }
    public function ubahdataappsettings($data)
    {
        $this->db->set('app_logo', $data['app_logo']);
        $this->db->set('app_email', $data['app_email']);
        $this->db->set('app_website', $data['app_website']);
        $this->db->set('app_privacy_policy', $data['app_privacy_policy']);
        $this->db->set('app_aboutus', $data['app_aboutus']);
        $this->db->set('app_address', $data['app_address']);
        $this->db->set('app_name', $data['app_name']);
        $this->db->set('app_description', $data['app_description']);
        $this->db->set('app_contact', $data['app_contact']);
        $this->db->set('geocode_key', $data['geocode_key']);
        $this->db->set('map_key', $data['map_key']);
        $this->db->set('fcm_key', $data['fcm_key']);
        $this->db->set('maintenance', $data['maintenance']);
        $this->db->set('background', $data['background']);
        $this->db->set('isotp', $data['isotp']);
        $this->db->set('upreff', $data['upreff']);
        $this->db->set('rewardreff', $data['rewardreff']);
        $this->db->set('mode', $data['mode']);
        $this->db->where('id', '1');
        $this->db->update('app_settings', $data);
    }
    public function datapelangganbyid($id)
    {
        $this->db->select('*');
        $this->db->from('pengguna');
        $this->db->where('uid', $id);
        $pelanggan = $this->db->get();
        return $pelanggan;
    }
    public function datafiturbyid($id)
    {
        $this->db->select('*');
        $this->db->from('fitur');
        $this->db->where('id', $id);
        $pelanggan = $this->db->get();
        return $pelanggan;
    }
    public function addtransaksi($data)
    {
        $this->db->insert('transaksi', $data);
    }
    public function addtransaksibelanja($data)
    {
        $this->db->insert('transaksi_belanja', $data);
    }
    function get_dataorder($id)
    {
        $this->db->select('*');
        $this->db->from('transaksi');
        $this->db->where('idtrans', $id);
        $loc = $this->db->get();
        return $loc;
    }
    public function get_transaksibyid($id)
    {
        $this->db->select('transaksi.*,pengguna.fullnama,pengguna.kontak,pengguna.foto,pengguna.alamat,fitur.fitur,fitur.layanan');
        $this->db->where('idtrans', $id);
        $this->db->join('fitur', 'transaksi.fitur = fitur.id', 'left');
        $this->db->join('pengguna', 'transaksi.iddriver = pengguna.uid', 'left');
        return $this->db->get('transaksi')->row_array();
       // return $this->db->get_where('transaksi', ['idtrans' => $id])->row_array();
    }
    public function transaksidriverbyid($id)
    {
        $this->db->select('transaksi.*,pengguna.fullnama,pengguna.kontak,pengguna.foto,pengguna.alamat,fitur.fitur AS service,fitur.layanan');
        $this->db->where('idtrans', $id);
        $this->db->join('fitur', 'transaksi.fitur = fitur.id', 'left');
        $this->db->join('pengguna', 'transaksi.idpelanggan = pengguna.uid', 'left');
        return $this->db->get('transaksi')->row_array();
    }
    public function databelanja($id)
    {
        $this->db->select('*');
        $this->db->where('idtrans', $id);
        return $this->db->get('transaksi_belanja')->row_array();
    }
    public function check_status_transaksi($idtrans)
    {
        $this->db->select('*');
        $this->db->from('transaksi');
        $this->db->where('idtrans', $idtrans);
        $cek = $this->db->get();
        if ($cek->num_rows() == 1) {
            return TRUE;
        } else {
            return FALSE;
        }
    }
    public function check_exist_transaksibyakun($akun)
    {
        $time = time();
        $exp = date("Y-m-d H:i:s", $time);
        $cek = $this->db->query("SELECT idtrans FROM transaksi where idpelanggan='$akun' AND expire > '$exp' ");
        if ($cek->num_rows() == 1) {
            return true;
        } else {
            return false;
        }
    }
    public function check_exist_transaksi($idtrans)
    {
        $time = time();
        $exp = date("Y-m-d H:i:s", $time);
        $cek = $this->db->query("SELECT idtrans FROM transaksi where idtrans='$idtrans' AND expire > '$exp' ");
        if ($cek->num_rows() == 1) {
            return true;
        } else {
            return false;
        }
    }
    public function check_exist_pengajuan($idtrans)
    {
        $time = time();
        $exp = date("Y-m-d H:i:s", $time);
        $cek = $this->db->query("SELECT idtrans FROM pengajuan where idtrans='$idtrans'");
        if ($cek->num_rows() == 1) {
            return true;
        } else {
            return false;
        }
    }
    public function check_exist_transaksibyid($idtrans)
    {
        $time = time();
        $exp = date("Y-m-d H:i:s", $time);
        $cek = $this->db->query("SELECT idtrans FROM transaksi where idtrans='$idtrans' AND expire > '$exp' AND status='0' ");
        if ($cek->num_rows() == 1) {
            return true;
        } else {
            return false;
        }
    }
    public function cek_ketersediaan_trx($idtrans){
        $this->db->select('pelanggan.*, saldo.saldo');
        $this->db->from('pelanggan');
        $this->db->join('saldo', 'pelanggan.id = saldo.id_user');
        $this->db->where('idtrans',$idtrans);
        return $this->db->get();
    }
    public function get_alltransaksi()
    {
        $time = time();
        $this->db->select('transaksi.*,fitur.icon,fitur.fitur as service,pengajuan.iddriver as idpengajuan');
        $this->db->join('fitur', 'transaksi.fitur = fitur.id', 'left');
        $this->db->join('pengajuan', 'transaksi.iddriver = pengajuan.iddriver', 'left');
        $this->db->where('transaksi.iddriver',null);
        $this->db->where('expire >', date("Y-m-d H:i:s", $time));
        return $this->db->get('transaksi')->result_array();
    }
    public function get_alltransaksibyakun($id)
    {
        $time = time();
        $this->db->select('transaksi.*,fitur.fitur,fitur.icon');
        $this->db->join('fitur', 'transaksi.fitur = fitur.id', 'left');
        $this->db->where('idpelanggan', $id);
        $this->db->where('status != 5');
        $this->db->where('expire >', date("Y-m-d H:i:s", $time));
        return $this->db->get('transaksi')->result_array();
    }
    public function alltransaksibyakun($id)
    {
        $time = time();
        $this->db->select('transaksi.*,fitur.fitur,fitur.icon');
        $this->db->join('fitur', 'transaksi.fitur = fitur.id', 'left');
        $this->db->where('idpelanggan', $id);
        $this->db->where('status != 5');
        $this->db->where('expire >', date("Y-m-d H:i:s", $time));
        return $this->db->get('transaksi');
    }
    public function get_transaksibyakun($id)
    {
        $this->db->select('transaksi.*,fitur.fitur,fitur.icon');
        $this->db->join('fitur', 'transaksi.fitur = fitur.id', 'left');
        $this->db->where('idpelanggan', $id);
        $this->db->where('status != 0');
       // $this->db->where('status != 4');
       // $this->db->where('status != 5');
       $this->db->order_by('waktu', 'DESC');
        return $this->db->get('transaksi')->result_array();
    }
    public function get_transaksibyakundriver($id)
    {
        $this->db->select('transaksi.*,fitur.fitur,fitur.icon,pengguna.fullnama');
        $this->db->join('fitur', 'transaksi.fitur = fitur.id', 'left');
        $this->db->join('pengguna', 'transaksi.idpelanggan = pengguna.uid', 'left');
        $this->db->where('iddriver', $id);
        $this->db->where('status != 0');
        $this->db->where('status != 1');
        $this->db->where('status != 2');
        $this->db->where('status != 3');
        $this->db->order_by('waktu', 'DESC');
        return $this->db->get('transaksi')->result_array();
    }
    public function countransaksidriver($id)
    {
        $this->db->where('status', '4');
        $this->db->where('iddriver', $id);
        return $this->db->get('transaksi')->result_array();
    }
    public function pendapatandriver($id){
        $this->db->select('*');
        $this->db->from('transaksi');
        $this->db->where('status', '4');
        $this->db->where('iddriver', $id);
        $cek = $this->db->get();
        $countdata = 0;
        $hasil = 0;
        if ($cek->num_rows() > 0) {
            foreach ($cek->result() as $row) {
                $countdata += $row->totalharga;
            }
            $hasil = $countdata;
        }
        return $hasil;
      }
    public function addtest($data)
    {
        $this->db->insert('demo', $data);
    }
    public function get_data_driver($lat, $lng)
    {
        $this->db->select("pengguna.uid,
            pengguna.fullnama,
            pengguna.alamat,
            pengguna.foto,
            pengguna.kontak,
            (6371 * acos(cos(radians($lat)) * cos(radians(latitude)) * cos(radians(longitude) - radians( $lng)) + sin(radians($lat)) * sin( radians(latitude)))) AS distance");
        $this->db->where('type', '1');
        $this->db->where('order_id', '0');
        $this->db->having('distance <= 5');  
        $this->db->order_by('distance', 'ASC');
        return $this->db->get('pengguna')->result_array();
    }
    public function aceeptrequest($data)
    {
        $this->db->set('totalharga', $data['harga']);
        $this->db->where('idtrans', $data['idtrans']);
        return $this->db->update('transaksi', $data);
    }
    public function acceptorder($data)
    {
        $this->db->where('uid', $data['iddriver']);
        $update_trans = $this->db->update('pengguna', array('order_id' => $data['idtrans']));

        $this->db->set('status', '1');
        $this->db->set('iddriver', $data['iddriver']);
        $this->db->set('token_driver', $data['token_driver']);
        $this->db->where('idtrans', $data['idtrans']);
        return $this->db->update('transaksi', $data);
    }
    public function acceptorderbypengajuan($data)
    {
        $this->db->where('uid', $data['iddriver']);
        $update_trans = $this->db->update('pengguna', array('order_id' => $data['idtrans']));

        $this->db->set('status', '1');
        $this->db->set('iddriver', $data['iddriver']);
        $this->db->set('token_driver', $data['token_driver']);
        $this->db->set('totalharga', $data['totalharga']);
        $this->db->where('idtrans', $data['idtrans']);
        return $this->db->update('transaksi', $data);
    }
    public function cancelorder($data)
    {
        $this->db->where('uid', $data['iddriver']);
        $update_trans = $this->db->update('pengguna', array('order_id' => '0'));

        $this->db->set('status', '5');
        $this->db->set('iddriver', $data['iddriver']);
        $this->db->where('idtrans', $data['id']);
        return $this->db->update('transaksi', $data);
    }
    public function updatekerja($data)
    {
        $this->db->set('order_id', $data['id']);
        $this->db->where('uid', $data['iddriver']);
        return $this->db->update('pengguna', $data);
    }
    public function datatransbyid($id)
    {
        $this->db->select('*');
        $this->db->from('transaksi');
        $this->db->where('idtrans', $id);
        $pelanggan = $this->db->get();
        return $pelanggan;
    }
    public function cekakundriver($id)
    {
        $this->db->select('*');
        $this->db->from('pengguna');
        $this->db->where('type', '1');
        $this->db->where('uid', $id);
        $pelanggan = $this->db->get();
        return $pelanggan;
    }
    public function setstatus($data)
    {
        $this->db->set('status', $data['status']);
        $this->db->where('idtrans', $data['id']);
        return $this->db->update('transaksi', $data);
    }
    public function resetstatus($data){
        $this->db->where('uid', $data['iddriver']);
        $update_trans = $this->db->update('pengguna', array('order_id' => '0'));
    }
    public function check_exist_driver()
    {
        $cek = $this->db->query("SELECT uid FROM pengguna where order_id = '0' AND type = '1' ");
        if ($cek->num_rows() == 1) {
            return true;
        } else {
            return false;
        }
    }
    public function cekorderanaktif($idtrans)
    {
        $time = time();
        $exp = date("Y-m-d H:i:s", $time);
        $cek = $this->db->query("SELECT idtrans FROM transaksi where idtrans='$idtrans' AND expire > '$exp' ");
        if ($cek->num_rows() == 1) {
            return true;
        } else {
            return false;
        }
    }
    public function cekorderanbyakun($akun)
    {
        $time = time();
        $exp = date("Y-m-d H:i:s", $time);
        $cek = $this->db->query("SELECT idpelanggan FROM transaksi where idpelanggan='$akun' AND expire > '$exp' ");
        if ($cek->num_rows() == 1) {
            return true;
        } else {
            return false;
        }
    }
    public function cekpengajuan($idtrans)
    {
        $time = time();
        $exp = date("Y-m-d H:i:s", $time);
        $cek = $this->db->query("SELECT idtrans FROM pengajuan where idtrans='$idtrans'");
        if ($cek->num_rows() == 1) {
            return true;
        } else {
            return false;
        }
    }
    public function cekpengajuanfilter($idtrans,$iddriver)
    {
        $time = time();
        $exp = date("Y-m-d H:i:s", $time);
        $cek = $this->db->query("SELECT idtrans FROM pengajuan where idtrans='$idtrans' AND iddriver = '$iddriver'");
        if ($cek->num_rows() == 1) {
            return true;
        } else {
            return false;
        }
    }
    public function dataallchat_driver($uid)
    {
        $this->db->select('transaksi.*,pengguna.fullnama');
        $this->db->join('pengguna', 'transaksi.idpelanggan = pengguna.uid', 'left');
        $this->db->where('transaksi.status != 0');
        $this->db->where('transaksi.status != 4');
        $this->db->where('transaksi.status != 5');
        $this->db->where('transaksi.iddriver', $uid);
        return $this->db->get('transaksi')->result_array();
    }
    public function dataallchat_customer($uid)
    {
        $this->db->select('transaksi.*,pengguna.fullnama');
        $this->db->join('pengguna', 'transaksi.iddriver = pengguna.uid', 'left');
        $this->db->where('transaksi.status != 0');
        $this->db->where('transaksi.status != 4');
        $this->db->where('transaksi.status != 5');
        $this->db->where('transaksi.idpelanggan', $uid);
        return $this->db->get('transaksi')->result_array();
    }
    public function datachat($id)
    {
        $this->db->select('chat.*,pengguna.*');
        $this->db->join('pengguna', 'chat.uid = pengguna.uid', 'left');
        $this->db->where('idtrans', $id);
        $this->db->order_by('waktu', 'ASC');
        return $this->db->get('chat')->result_array();
    }
    function get_datahchat($id)
    {
        $this->db->select('chat.*,pengguna.*,chat.level as levelchat');
        $this->db->from('chat');
        $this->db->join('pengguna', 'chat.uid = pengguna.uid', 'left');
        $this->db->where('idtrans', $id);
        $this->db->order_by('waktu', 'ASC');
        $loc = $this->db->get();
        return $loc;
    }
    public function get_transaksiprogesss($id)
    {
        $this->db->select('transaksi.*,fitur.icon,fitur.fitur as service');
        $this->db->join('fitur', 'transaksi.fitur = fitur.id', 'left');
        $this->db->where('iddriver', $id);
        $this->db->where('status != 4');
        $this->db->where('status != 5');
        return $this->db->get('transaksi')->result_array();
    }
    function get_dataprogress()
    {
        $time = time();
        $this->db->select('transaksi.*,fitur.icon,fitur.fitur as service');
        $this->db->from('transaksi');
        $this->db->join('fitur', 'transaksi.fitur = fitur.id', 'left');
        $this->db->where('transaksi.iddriver',null);
        //$this->db->where('expire >', date("Y-m-d H:i:s", $time));
        $loc = $this->db->get();
        return $loc;
    }
    public function postchat($data)
    {
        $this->db->insert('chat', $data);
    }
    public function editfitur($data)
    {
        $this->db->set('fitur', $data['fitur']);
        $this->db->set('harga', $data['harga']);
        $this->db->set('minharga', $data['minharga']);
        $this->db->set('minjarak', $data['minjarak']);
        $this->db->set('diskon', $data['diskon']);
        $this->db->set('parkir', $data['parkir']);
        $this->db->set('icon', $data['icon']);
        $this->db->set('layanan', $data['layanan']);
        $this->db->set('page', $data['layanan']);
        $this->db->set('status', $data['status']);
        $this->db->where('id', $data['id']);
        return $this->db->update('fitur', $data);
    }
    public function hapusfitur($id)
    {
        $this->db->where('id', $id);
        $this->db->delete('fitur');
    }
    public function editakun($data)
    {
        $this->db->set('fullnama', $data['fullnama']);
        $this->db->set('username', $data['username']);
        $this->db->set('password', $data['password']);
        $this->db->set('email', $data['email']);
        $this->db->set('foto', $data['foto']);
        $this->db->where('uid', $data['uid']);
        return $this->db->update('pengguna', $data);
    }
    public function hapusakun($id)
    {
        $this->db->where('uid', $id);
        $this->db->delete('pengguna');
    }
    public function editsetting($data)
    {
        $this->db->set('appname', $data['appname']);
        $this->db->set('alamat', $data['alamat']);
        $this->db->set('kontak', $data['kontak']);
        $this->db->set('email', $data['email']);
        $this->db->set('logo_white', $data['logo_white']);
        $this->db->set('logo_dark', $data['logo_dark']);
        $this->db->set('wagateway', $data['wagateway']);
        $this->db->set('maintenance', $data['maintenance']);
        $this->db->where('id', $data['id']);
        return $this->db->update('settings', $data);
    }
    public function addfitur($data)
    {
        $this->db->insert('fitur', $data);
    }
    public function updatetoken($data)
    {
        $this->db->set('token', $data['token']);
        $this->db->where('uid', $data['uid']);
        return $this->db->update('pengguna', $data);
    }
    //---------------------------- Kirim Notifikasi -------------------------------------------
    public function kirimnotif($registrationIDs,$data){
        define( 'API_ACCESS_KEY', 'AAAAk0L3g54:APA91bEzxwLuij6gQ-_dPxUjwgX6IWPiAiEKBWOX4mjdmkXtBfiY4_ssWR2m87OrGIBaCL_0ddOlwASwBuZ83HILLmEuHtfWzEviBqvI8V9rKi6c5lQJlECMTODp12IGuKo8-hIuCH-h');
        $fcmUrl = 'https://fcm.googleapis.com/fcm/send';
        $notification = [
            'title' => $data['title'],
            'body' => $data['body'],
            'icon' => base_url().'images/notification.png', 
            'sound' => base_url().'sound/notifikasi.mp3',
            'click_action' => $data['link']
        ];
        $extraNotificationData = ["message" => $notification,"type" =>$data['type'],"transaksi" =>$data['idtrans'],"link" =>$data['link']];

        $fcmNotification = [
            //'registration_ids' => $tokenList, //multple token array
            'registration_ids'  => $registrationIDs,
            'notification' => $notification,
            'data' => $extraNotificationData,
            "priority" => "high"
        ];

        $headers = [
            'Authorization: key=' . API_ACCESS_KEY,
            'Content-Type: application/json'
        ];


        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL,$fcmUrl);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fcmNotification));
        $result = curl_exec($ch);
        curl_close($ch);
    }
    public function insertpengajuan($data)
    {
        $this->db->insert('pengajuan', $data);
    }
    public function updatepengajuan($data)
    {
        $this->db->set('pengajuan', $data['pengajuan']);
        $this->db->where('iddriver', $data['iddriver']);
        $this->db->where('idtrans', $data['idtrans']);
        return $this->db->update('pengajuan', $data);
    }
}
